#!/bin/bash

localJobId=$1
instanceId=$2

tarballInput=${_tapisSysRootDir}/${tarballInput}
tarballInputTimeTransferred=${_tapisSysRootDir}/${tarballInputTimeTransferred}

export DISPLAY=
for xdgenv in $(printenv | grep ^XDG_ | sed -e "s:=.*::") ; do
   unset ${xdgenv}
done

tar xf ${tarballInput}
exitStatus=$?
if [ ${exitStatus} -eq 0 ] ; then
   tar xf ${tarballInputTimeTransferred}
   exitStatus=$?
   if [ ${exitStatus} -eq 0 ] ; then
      touch .__fileTimeMarker
      sleep 1
   fi
fi

#rm -f ${tarballInput}
#rm -f ${tarballInputTimeTransferred}

find . -type f -not -name md5sums.start -exec md5sum {} \; > md5sums.start

if [ -f .__fileTimeMarker ] ; then
   touch .__fileTimeMarker
   sleep 1
fi

if [ -f .__timestamp_transferred.${localJobId}_${instanceId} ] ; then
   touch .__timestamp_transferred.${localJobId}_${instanceId}
fi

. ${localJobId}_${instanceId}.sh

if [ ${exitStatus} -eq 0 ] ; then
   if [ -f tapis_${localJobId}_${instanceId}.stdout ] ; then
      touch tapis_${localJobId}_${instanceId}.stdout
   fi
   if [ -f tapis_${localJobId}_${instanceId}.stderr ] ; then
      touch tapis_${localJobId}_${instanceId}.stderr
   fi

   stageOutTarfile=${localJobId}_${instanceId}_output.tar
   find . -newer .__fileTimeMarker -not -name . -print0 | \
      xargs --null --no-run-if-empty tar rf ${stageOutTarfile} --no-recursion
   exitStatus=$?
   if [ ${exitStatus} -eq 0 ] ; then
      if [ -f ${stageOutTarfile} ] ; then
         gzip ${stageOutTarfile}
         exitStatus=$?
      fi
   fi
fi

