#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         Scripts/tapis3/createUserCredential.sh
# @copyright    Copyright 2024-2025 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2024-2025 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
#
if [ $# -lt 2 ] ; then
   echo "usage: $0 systemId userCredentialDefinitionFile [userCredentialDefinitionResponseFile]"
   exit 64
fi

binDirectory=$(dirname $(readlink -f $0))

systemId=$1

if [ -f $2 ] ; then
   userCredentialDefinitionFile=$2
   if [ $# -gt 2 ] ; then
      userCredentialDefinitionResponseFile=$3
   else
      userCredentialDefinitionResponseFile=
   fi
else
   if [ -f ${binDirectory}/SystemDefinitions/$2_credential.json ] ; then
      userCredentialDefinitionFile=${binDirectory}/SystemDefinitions/$2_credential.json
      if [ $# -gt 2 ] ; then
         userCredentialDefinitionResponseFile=$3
      else
         userCredentialDefinitionResponseFile=${binDirectory}/SystemDefinitions/$2_credential_response.json
      fi
   else
      echo "user credential definition file $2 can not be located"
      exit 1
   fi
fi

python3.11 ${binDirectory}/createUserCredential.py ${systemId} \
                                                   ${userCredentialDefinitionFile} \
                                                   ${userCredentialDefinitionResponseFile}
exitStatus=$?

exit ${exitStatus}
