#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         Scripts/tapis2/updatetimetransferred.sh
# @copyright    Copyright 2004-2022 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2022 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
if [ $# -ne 3 ] ; then
   echo usage: $0 systemId instanceToken stagingHandle
   exit 64
fi

systemId=$1
instanceToken=$2
stagingHandle=$3

binDirectory=$(dirname $(readlink -f $0))

workingPath=$(mktemp --directory)

cd ${workingPath}
exitStatus=$?

if [ ${exitStatus} -eq 0 ] ; then
   timeTransferredTarFile=${stagingHandle}_timetransferred.tar

   python3 ${binDirectory}/downloadFile.py ${systemId} \
                                           JobInputs/${instanceToken}/${timeTransferredTarFile}.gz
   exitStatus=$?

   if [ ${exitStatus} -eq 0 ] ; then
      gunzip ${timeTransferredTarFile}.gz
      exitStatus=$?
      if [ ${exitStatus} -eq 0 ] ; then
         timestampTransferredFile=.__timestamp_transferred.${stagingHandle}
         now=$(date +"%s")
         echo ${now} > ${timestampTransferredFile}
         if [ -r ${timestampTransferredFile} ] ; then
            tar rf ${timeTransferredTarFile} ${timestampTransferredFile}
            exitStatus=$?
            if [ ${exitStatus} -eq 0 ] ; then
               gzip ${timeTransferredTarFile}
               exitStatus=$?
               if [ ${exitStatus} -eq 0 ] ; then
                  python3 ${binDirectory}/uploadFile.py ${timeTransferredTarFile}.gz ${systemId} \
                                                        JobInputs/${instanceToken} > /dev/null
                  exitStatus=$?
                  if [ ${exitStatus} -ne 0 ] ; then
                     echo "Failed to upload ${timeTransferredTarFile}.gz"
                  fi
               else
                  echo "Failed to gzip ${timeTransferredTarFile}"
               fi
            else
               echo "Failed to add timestamp transferred file to ${timestampTransferredFile}"
            fi
         else
            echo "Failed to create timestamp transferred file"
            exitStatus=1
         fi
      else
         echo "Failed to gunzip ${timeTransferredTarFile}.gz"
      fi
   else
      echo "Failed to download ${timeTransferredTarFile}.gz"
   fi
   rm -f ${timeTransferredTarFile} ${timeTransferredTarFile}.gz
else
   echo "Failed to create temporary working directory"
fi

cd /tmp

if [ -d "${workingPath}" ] ; then
   rm -rf ${workingPath}
fi

exit ${exitStatus}
