#!/usr/bin/env python3
#
# @package      hubzero-submit-monitors
# @file         monitorJobS.py
# @copyright    Copyright (c) 2004-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
# ----------------------------------------------------------------------
#  monitorJobS.py
#
#  script which notifies monitorJob.py of a new job submission
#
import os
import sys
import logging

from hubzero.submit.ApplicationUtilities import ApplicationUtilities as ApplicationUtilities
from hubzero.submit.DaemonsInfo          import DaemonsInfo
from hubzero.submit.RemoteJobMonitor     import RemoteJobMonitor

SUBMITUTILITYLOGLEVEL = "ERROR"

DAEMONSDIRECTORY         = os.path.join(os.sep,"etc","submit")
DAEMONSCONFIGURATIONFILE = 'daemons.conf'

def monitorJobS(listenURI):
   """new job Submission"""
   session          = sys.argv[1]
   instanceToken    = sys.argv[2]
   wsJobId          = sys.argv[3]
   siteName         = sys.argv[4]
   identityManagers = [sys.argv[5]]
   siteDesignator   = sys.argv[6]
   remoteJobId      = sys.argv[7]
   hubUserId        = sys.argv[8]
   jobWorkDirectory = sys.argv[9]
   enteredCommand   = sys.argv[10]
   localJobId       = sys.argv[11]
   instanceId       = sys.argv[12]
   destination      = sys.argv[13]
   runName          = sys.argv[14]
   nCores           = sys.argv[15]
   distributorPid   = sys.argv[16]

   remoteJobMonitor = RemoteJobMonitor(listenURI)

   tailFiles = []
   remoteJobMonitor.postJobSubmission(session,
                                      instanceToken,
                                      wsJobId,
                                      siteName,
                                      identityManagers,
                                      siteDesignator,
                                      remoteJobId,hubUserId,
                                      tailFiles,enteredCommand,
                                      jobWorkDirectory,
                                      localJobId,instanceId,destination,runName,nCores,distributorPid)


if __name__ == '__main__':
   submitUtilityLogLevel    = os.getenv("SUBMITUTILITYLOGLEVEL",SUBMITUTILITYLOGLEVEL)
   daemonsDirectory         = os.getenv("DAEMONSDIRECTORY",DAEMONSDIRECTORY)
   daemonsConfigurationFile = os.getenv("DAEMONSCONFIGURATIONFILE",DAEMONSCONFIGURATIONFILE)

   applicationUtilities = ApplicationUtilities(SUBMITUTILITYLOGLEVEL)
   applicationUtilities.openStreamLogger(sys.stderr,
                                         submitUtilityLogLevel)

   configFilePath = os.path.join(daemonsDirectory,daemonsConfigurationFile)
   daemonsInfo    = DaemonsInfo(configFilePath)
   listenURI      = daemonsInfo.getDaemonListenURI('jobMonitor','tcp')

   monitorJobS(listenURI)


